#!/usr/bin/env python

from qiling import *
from capstone import *


# https://github.com/avast/retdec/blob/master/src/capstone2llvmirtool/capstone2llvmir.cpp


def hook_callback(ql, address, size):
    # read current instruction bytes
    data = ql.mem.read(address, size)
    # initialize Capstone
    md = Cs(CS_ARCH_MIPS, CS_MODE_MIPS32)
    # disassemble current instruction
    for i in md.disasm(data, address):
        print("[*] 0x{:08x}: {} {}".format(i.address, i.mnemonic, i.op_str))


def stop(ql):
    print("killerswtichfound")
    ql.console = True


def main(enable_trace):
    env_vars = {
        "REQUEST_METHOD": "POST",
        "REQUEST_URI": "/cgi-bin/login",
        "CONTENT-TYPE": "application/x-www-form-urlencoded",
        "REMOTE_ADDR": "127.0.0.1",
        "REMOTE_PORT": "80",
        # "HTTP_COOKIE": "noneed=1",
        "QUERY_STRING": "user=echel0n&password=ILOVEQILING&redirect=" + "A" * 0x1000,  # fill here
    }

    ql = Qiling(
        filename=["/home/qiling_projects/Airties/5650v3TT/squashfs-root/webs/cgi-bin/login"],
        rootfs="/home/qiling_projects/Airties/5650v3TT/squashfs-root/",
        output="debug",
        env=env_vars,
        console=True if enable_trace else False,
    )

    ql.debugger = True

    
    ql.run()
    input("done?")


if __name__ == "__main__":
    main(True)
