/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.InvalidFileNameException;

public final class Streams {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private Streams() {
    }

    public static long copy(InputStream pInputStream, OutputStream pOutputStream, boolean pClose) throws IOException {
        return Streams.copy(pInputStream, pOutputStream, pClose, new byte[8192]);
    }

    public static long copy(InputStream pIn, OutputStream pOut, boolean pClose, byte[] pBuffer) throws IOException {
        OutputStream out = pOut;
        InputStream in = pIn;
        try {
            int res;
            long total = 0L;
            while ((res = in.read(pBuffer)) != -1) {
                if (res <= 0) continue;
                total += (long)res;
                if (out == null) continue;
                out.write(pBuffer, 0, res);
            }
            if (out != null) {
                if (pClose) {
                    out.close();
                } else {
                    out.flush();
                }
                out = null;
            }
            in.close();
            in = null;
            long l = total;
            return l;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
            if (pClose && out != null) {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static String asString(InputStream pStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Streams.copy(pStream, baos, true);
        return baos.toString();
    }

    public static String asString(InputStream pStream, String pEncoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Streams.copy(pStream, baos, true);
        return baos.toString(pEncoding);
    }

    public static String checkFileName(String pFileName) {
        if (pFileName != null && pFileName.indexOf(0) != -1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < pFileName.length()) {
                char c = pFileName.charAt(i);
                switch (c) {
                    case '\u0000': {
                        sb.append("\\0");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            throw new InvalidFileNameException(pFileName, "Invalid file name: " + sb);
        }
        return pFileName;
    }
}

