import socket
import time


def send_tcp_request(ip_address, port, http_request):
    vuln = False
    sock = None
    try:
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.settimeout(60)

        server_address = (ip_address, port)
        print(f"Connecting to {ip_address} port {port}")
        sock.connect(server_address)

        start_time = time.time()

        print(f"Sending {repr(http_request)}")
        sock.sendall(http_request.encode())

        data = sock.recv(16)
        if not data:
            vuln = True
            print(f"No response received, server may be vulnerable.")
        else:
            while data:
                print(f"Received: {data.decode()}")
                data = sock.recv(16)

        elapsed_time = time.time() - start_time
        print(f"Elapsed time: {elapsed_time} seconds")

    except socket.timeout:
        vuln = True
        print(f"Socket timeout, server may be vulnerable.")
    except socket.error as e:
        print(f"Socket error: {e}")
    finally:
        if sock is not None:
            print("Closing socket")
            sock.close()

    return vuln


input_ip = input("Enter the host/IP address: ")
input_port = int(input("Enter the port: "))

# sending bad request
bad_request = "GET / HTTP/1.0\n\n"
print("\n=== Sending bad request ===")
is_vulnerable = send_tcp_request(input_ip, input_port, bad_request)
print(f"\nServer vulnerability status: {is_vulnerable}")

# sending good request
proper_request = f"GET / HTTP/1.1\r\nHost: {input_ip}\r\nConnection: Close\r\n\r\n"
print("\n=== Sending good request ===")
is_vulnerable = send_tcp_request(input_ip, input_port, proper_request)
print(f"\nServer vulnerability status: {is_vulnerable}")
