# CVE-1999-0524 - ICMP Timestamp and Address Mask Request Exploit

## Description

This tool is designed to target CVE-1999-0524, a vulnerability in the ICMP protocol, which allows arbitrary hosts to send ICMP Timestamp and Address Mask requests to a target system. This can expose sensitive network information or lead to DoS (Denial of Service) attacks.

**Author:** Afif Hidayatullah  
**Organization:** ITSEC Asia

## Features

- Send ICMP Timestamp or Address Mask requests.
- Option to check if a specific port is open before sending ICMP requests.
- Support for bulk processing multiple IP addresses/domains from a file.
- Output responses or errors to a specified file.
- Handle both IP addresses and domain names.

---

## Requirements

- Python 3.x
- Administrative privileges (required for sending raw ICMP packets)

---

## Installation

To use this tool, simply clone the repository and run the script.

```bash
git clone https://github.com/threatlabindonesia/CVE-1999-0524-ICMP-Timestamp-and-Address-Mask-Request-Exploit.git
cd CVE-1999-0524-ICMP-Timestamp-and-Address-Mask-Request-Exploit
python3 CVE-1999-0524.py
```

---

## Usage

### Command Line Arguments

```bash
usage: CVE-1999-0524.py [-h] [--type TYPE] [--code CODE] [--output OUTPUT] [--port PORT] [--bulk] target
```

#### Positional Arguments:
- **`target`**  
  Target IP address or domain name, or a file containing a list of IPs/domains.

#### Optional Arguments:
- **`-h, --help`**  
  Show help message and exit.

- **`--type TYPE`**  
  ICMP Type (default is `13` for Timestamp Request).  
  Example: `--type 17` for Address Mask Request.

- **`--code CODE`**  
  ICMP Code (default is `0`).

- **`--output OUTPUT`**  
  File to export the output (default is no output).  
  Example: `--output results.txt`

- **`--port PORT`**  
  Port number to check for an open connection (optional). If not provided, only IP will be used for ICMP requests.  
  Example: `--port 80` to check HTTP port.

- **`--bulk`**  
  Process multiple IPs from a file. If this flag is set, the script will read from the file provided as the target and process each line as an individual target.

---

## Example Usage

### Sending ICMP requests to a single IP address:

```bash
python CVE-1999-0524.py 192.168.1.1 --type 13 --code 0 --output output.txt --port 80
```

This sends an ICMP Timestamp request to `192.168.1.1`, checks if port 80 is open, and saves the output to `output.txt`.

### Sending ICMP requests to multiple IPs from a file:

```bash
python CVE-1999-0524.py targets.txt --bulk --output output.txt
```

This reads a list of IPs/domains from `targets.txt`, sends ICMP Timestamp requests to each, and exports the responses to `output.txt`.

### Sending Address Mask request with no port check:

```bash
python CVE-1999-0524.py 192.168.1.2 --type 17 --code 0
```

This sends an ICMP Address Mask request to `192.168.1.2`.

---

## Example Output

### When a response is received:

```
[2024-11-25 12:34:56] Received response from 192.168.1.1:
00000000  00 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00  |................|
00000010  00 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00  |................|
```

### When no response is received:

```
No response received from 192.168.1.1.
```

### When a port is closed:

```
Port 80 is closed on 192.168.1.1. Skipping ICMP request.
```

---

## Output File Example

If the `--output` option is used, each result will be saved to the specified file, and the file will look like this:

```txt
Target: 192.168.1.1
[2024-11-25 12:34:56] Received response from 192.168.1.1:
00000000  00 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00  |................|
00000010  00 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00  |................|

Target: 192.168.1.2
No response received from 192.168.1.2.
```

---

## Additional Notes

- **Permissions:** This script requires administrative privileges to send raw ICMP packets. On Linux, you may need to run the script with `sudo`.
- **Bulk File Format:** Each line in the bulk file should contain a single IP address or domain name. No additional formatting is required.
- **Output Format:** The script will log each response with a timestamp. If no response is received, it will log a timeout message.

---

## Contact

If you have any questions or suggestions, feel free to reach out to the author:

- **Afif Hidayatullah**  
  Email: afif@itsecasia.com  
  Linkedin: [AfifHidayatullah](https://www.linkedin.com/in/afif-hidayatullah/)  
  Website: [www.itsec.asia](https://www.itsec.asia)

---
